import { MemoryDb } from './memorydb'
import { IdGen } from './idgen'
import { DataGen } from './datagen'

import { Tokenization } from './tokenization'

export class Data {
    private _hamlet: string[]
    private provider: MemoryDb
    private datagen: DataGen
    private _isInit: boolean = false
    private generators: any
    private tokenizations: { [name: string]: Tokenization; } = {}

    constructor(strategy: any) {
        this.datagen = new DataGen()
        this.provider = new MemoryDb(strategy)
        this.generators = {}
        this.generators['da:contacts'] = () => {
            // for (let i = 0; i < 40; i++) {
            //     this.provider.insert('da:contacts', IdGen.generate(), {
            //         name: this.datagen.fullname(),
            //         phone: Math.floor(100000000 + Math.random() * 900000000)
            //     })
            // }
        }
        this.generators['contacts'] = () => {
            // this.provider.insert('contacts', IdGen.generate(), { name: "Lincoln Bailey", phone: 279061454 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Anderson Cohen", phone: 375687352 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Lennox Dawson", phone: 132052839 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Tucker Adler", phone: 647086892 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Avery Gibbs", phone: 976007174 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Arden Copeland", phone: 406830104 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Bailey Adair", phone: 240445375 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Quinn Jackson", phone: 689546223 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Quinn Duncan", phone: 410827879 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Addison Carson", phone: 364975519 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Luna Hutton", phone: 895438587 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Riley Sutton", phone: 181673586 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Jefferson Luna", phone: 871089896 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Gibbs Murphy", phone: 118267647 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Cohen Carson", phone: 245254111 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Stone Cohen", phone: 896750780 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Slater Miller", phone: 177572545 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "McKenna Cohen", phone: 347545283 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Brady Ashley", phone: 178788287 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Everly Wilson", phone: 530862774 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Kramer Taylor", phone: 170931955 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Peyton Griffin", phone: 464343839 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Addison Beckett", phone: 423679611 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Jefferson Rose", phone: 615582932 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Presley Anderson", phone: 886737540 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Grady Bailey", phone: 392489442 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Kim Harrison", phone: 320056289 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Dawson Tyler", phone: 371577776 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Stone Addison", phone: 194273111 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Quinn Riley", phone: 421647197 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Carson Marshall", phone: 814681601 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Harper Davis", phone: 432116542 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Marley McKenna", phone: 730402127 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Tucker Madigan", phone: 369610730 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Tyler Wilson", phone: 697885565 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Thompson Harper", phone: 251614800 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Madigan Cassidy", phone: 885441706 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Parker Kennedy", phone: 751082520 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Bardot Emerson", phone: 886006292 })
            // this.provider.insert('contacts', IdGen.generate(), { name: "Marley Adair", phone: 496912427 })
            // for (let i = 0; i < 40; i++) {
            // this.provider.insert('contacts', IdGen.generate(), {
            //     name: this.datagen.fullname(),
            //     phone: Math.floor(100000000 + Math.random() * 900000000)
            // })
            // }
        }
        const $toSentenceCase = text => text.replace(/(^[a-z])|(\s+[a-z])/g, txt => { return txt.toUpperCase() })
        this.generators['updates'] = () => {
            // this.provider.insert('updates', IdGen.generate(), { text: "Mereliðende Werede Cræftig" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Sorh Stande Hondræs Biorh" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Elne Sece Mercelses" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Hwilum Strenge Mergen" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Wælræse Grames Gehealdan Ymbe" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Holinga Ferh Geblodegod þrio" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Forstode Eaforheafodsegn" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Fin Eafoþes ðeod" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Modes" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Hi Banhus" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Liges Gescæphwile" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Angan Lufode Gefeoll Ferhþum" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Fotes" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Gebidanne Hildebille ætberan" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Scipherge" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Wordhord æþelu" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Gecrang Torht Heofones" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Bolda" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Siþðan Dracan Deore" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Gemet Hilderinc" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Tosomne Mearas Madmas Gefetian" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Weredon Unsofte Wearð" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Liðwæge þreatedon Colran" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Sigora Bealwe Est" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Sidfæþme Hringweorðunge Gymeð Cræftum" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Wræte Nyde" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Ymbe Compe þancedon Leodbealo" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Bealohydig æðelinga" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Norðdenum Sælac Nemne" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Hors Spræcon" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Breþer Heaþoræsas" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Oðð Cynne Arum Cenoste" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Guman Wælgæst Hnah" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Wage Ealdfæder Guða" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Slog" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Maþme Full Læded" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Benc" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Yppan" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Hydan Togen Ofsloh Modega" })
            // this.provider.insert('updates', IdGen.generate(), { text: "Gleomannes Beadorinca Bryd" })
            // for (let i = 0; i < 40; i++) {
            // this.provider.insert('updates', IdGen.generate(), {
            //     text: $toSentenceCase(this.datagen.beowulf(Math.random() * 4)),
            // })
            // }
        }
        this.generators['news'] = () => {
            // this.provider.insert('news', IdGen.generate(), { text: "Hlifade Gehwylcum Wunder Eorlum" })
            // this.provider.insert('news', IdGen.generate(), { text: "Side Mandryhtnes" })
            // this.provider.insert('news', IdGen.generate(), { text: "Freoge" })
            // this.provider.insert('news', IdGen.generate(), { text: "Heorodreorigne Randwigan" })
            // this.provider.insert('news', IdGen.generate(), { text: "Breat Agangen" })
            // this.provider.insert('news', IdGen.generate(), { text: "Hildemeceas" })
            // this.provider.insert('news', IdGen.generate(), { text: "Ceap ðec Neosan" })
            // this.provider.insert('news', IdGen.generate(), { text: "Beorncyning" })
            // this.provider.insert('news', IdGen.generate(), { text: "Sliðen" })
            // this.provider.insert('news', IdGen.generate(), { text: "þinceð Tyn Handbanan Mago" })
            // this.provider.insert('news', IdGen.generate(), { text: "Stundum Ontyhte Sorhcearig" })
            // this.provider.insert('news', IdGen.generate(), { text: "Fyra" })
            // this.provider.insert('news', IdGen.generate(), { text: "Lagustræte Aldorgedal" })
            // this.provider.insert('news', IdGen.generate(), { text: "Abreat ðeoden Deaðes Furðum" })
            // this.provider.insert('news', IdGen.generate(), { text: "Bere Heaþoswata" })
            // this.provider.insert('news', IdGen.generate(), { text: "Fitela Grames" })
            // this.provider.insert('news', IdGen.generate(), { text: "Sægeata Reced þing Wæter" })
            // this.provider.insert('news', IdGen.generate(), { text: "Harne Niðe Lifwraþe" })
            // this.provider.insert('news', IdGen.generate(), { text: "Aglæcwif Sigeleasne Becn Wihstanes" })
            // this.provider.insert('news', IdGen.generate(), { text: "Mægð Ywde Swealg" })
            // this.provider.insert('news', IdGen.generate(), { text: "Gemette Weorc" })
            // this.provider.insert('news', IdGen.generate(), { text: "æfter Eorþan Geonga" })
            // this.provider.insert('news', IdGen.generate(), { text: "Maþðumgife Nihtum Sigeeadig" })
            // this.provider.insert('news', IdGen.generate(), { text: "Geocor Eorclanstanas" })
            // this.provider.insert('news', IdGen.generate(), { text: "Underne Angan Telge" })
            // this.provider.insert('news', IdGen.generate(), { text: "Fyrena Gefandod Buan Ombiht" })
            // this.provider.insert('news', IdGen.generate(), { text: "Angan Gingæste" })
            // this.provider.insert('news', IdGen.generate(), { text: "Gomene Geomore Entiscne" })
            // this.provider.insert('news', IdGen.generate(), { text: "Wæpen" })
            // this.provider.insert('news', IdGen.generate(), { text: "Ofercomon Hildehlemma Dæd" })
            // this.provider.insert('news', IdGen.generate(), { text: "Godfremmendra þohte Gegncwida Werigmod" })
            // this.provider.insert('news', IdGen.generate(), { text: "Yþgesene Dæghrefne Fyrdraca Rince" })
            // this.provider.insert('news', IdGen.generate(), { text: "Geongum" })
            // this.provider.insert('news', IdGen.generate(), { text: "Beadurofes" })
            // this.provider.insert('news', IdGen.generate(), { text: "Eatol Besnyðede" })
            // this.provider.insert('news', IdGen.generate(), { text: "Niðe Abealch þystrum" })
            // this.provider.insert('news', IdGen.generate(), { text: "Cnysedan Eorlscype Gio Elles" })
            // this.provider.insert('news', IdGen.generate(), { text: "Fenfreoðo Gomelan Leofestan" })
            // this.provider.insert('news', IdGen.generate(), { text: "Eatolne" })
            // this.provider.insert('news', IdGen.generate(), { text: "Cymeð Gewræc Eofores Herenið" })
            // for (let i = 0; i < 40; i++) {
            // this.provider.insert('news', IdGen.generate(), {
            //     text: $toSentenceCase(this.datagen.beowulf(Math.random() * 4)),
            // })
            // }
        }
        this.generators['content'] = () => {
            // this.provider.insert('content', IdGen.generate(), { title: "hollow", text: "afraid garments yawn statists bisson loud stirrd w…t resolutes feeds pioner suppliance endure thinkt" })
            // this.provider.insert('content', IdGen.generate(), { title: "patches snatches stealers drabbing", text: "forgetting being revels twelve likes dark writ log…ine deer aeneas sterling yes deer works converted" })
            // this.provider.insert('content', IdGen.generate(), { title: "only vouchsafe", text: "guest fast returns sledded falsehood fee breeder p…silence again loud reels impartment adoption wide" })
            // this.provider.insert('content', IdGen.generate(), { title: "residence", text: "quoted alack havior taint affection picture scorns…thousand utterd acted too moods journeymen dreamt" })
            // this.provider.insert('content', IdGen.generate(), { title: "advantage ladys book fret unsure digged fruitful", text: "market against controversy profoundest porches mou…ons minds possession such speed stowed pestilence" })
            // this.provider.insert('content', IdGen.generate(), { title: "turbulent exception treble instrument round captain horridly", text: "wrist towering infect palpable sadly at countrys i… crowing harlots you invite allow drowned younger" })
            // this.provider.insert('content', IdGen.generate(), { title: "touch huge faild perfume access swounds", text: "prolongs quarry stirring main paragon particular w…changed longed pastime spite loss reynaldo kissed" })
            // this.provider.insert('content', IdGen.generate(), { title: "whored sum", text: "spread still between woodcocks spring colleagued l…s delicate commended blessd parching father sober" })
            // this.provider.insert('content', IdGen.generate(), { title: "march weight likewise yon solicited sepulchre letters", text: "in equal nods hideous dumbshow mass" })
            // this.provider.insert('content', IdGen.generate(), { title: "immediately", text: "trifling sure wills lock yon being courtesy amaze …ning persuade finding forestall lecherous commend" })
            // this.provider.insert('content', IdGen.generate(), { title: "uneffectual comma", text: "copied illume drown forms threatening recks sixtee…me thunder sides commend easy mean begins possess" })
            // this.provider.insert('content', IdGen.generate(), { title: "hid peace", text: "faction auntmother fallingoff pile belike holla un…aling chamberdoor prating met dizzy money kingdom" })
            // this.provider.insert('content', IdGen.generate(), { title: "hymen accounted statists", text: "sweaty behavior baptista arrant mope indentures mind cellarage quillets handsome" })
            // this.provider.insert('content', IdGen.generate(), { title: "emphasis wiseness wagered paddock took", text: "waste prey fault sundays deserved withinheaven con…onjoind seafight serve behold rites tablebook try" })
            // this.provider.insert('content', IdGen.generate(), { title: "muddy", text: "supervise bray twerei blench impotent hey infallib…itied had greatness breaking million honesty ears" })
            // this.provider.insert('content', IdGen.generate(), { title: "backed jot", text: "stoops daughtermy violent pours superfluous pound …ults unyoke adheres redeliver distinguish grounds" })
            // this.provider.insert('content', IdGen.generate(), { title: "teeth limed", text: "warrant combination happiness thine alls importuni…cant accounted repast clutch spills chiefly death" })
            // this.provider.insert('content', IdGen.generate(), { title: "wildness beggar pinch whereon", text: "tenable trumpet fiery doubts dane property capons …d they gravemaking distraction infinite purgation" })
            // this.provider.insert('content', IdGen.generate(), { title: "tether vulgar danes angle smart fines", text: "changeling faithful black northerly dark thicker g…ithe incestuous path share encounter mutes impart" })
            // this.provider.insert('content', IdGen.generate(), { title: "seald seeming freeze", text: "priam water night possession report dared harlot ministers" })
            // this.provider.insert('content', IdGen.generate(), { title: "creep dies baser", text: "what oerweigh house counter what declining suddenl…ing boughs found roughly forward heavy recoveries" })
            // this.provider.insert('content', IdGen.generate(), { title: "large vantage", text: "lisp tenable honeying rebellion content hearers ca…ed meed start stronger oppression danskers sailor" })
            // this.provider.insert('content', IdGen.generate(), { title: "naught dropping horatioor scapes wringing remiss morn", text: "shook endure distrust handsome" })
            // this.provider.insert('content', IdGen.generate(), { title: "shroud thoult instance quillets", text: "thee friends uses blackest beneath liquid lecherou…t returneth borrowing moral hire snatches falsely" })
            // this.provider.insert('content', IdGen.generate(), { title: "fordoes havoc discretion overdone adulterate", text: "losing had scattering fares woo terms fitted profa…ins waste twain turnst hearts obscure ay sir lisp" })
            // this.provider.insert('content', IdGen.generate(), { title: "seems", text: "sucked foreknowing scourge build headshake brands …ons base new termagant blush pronouncing breathes" })
            // this.provider.insert('content', IdGen.generate(), { title: "divine exercises otherwise easier", text: "sharp lies killed possess desire above secrecy let… courtesy rank mutines estimation wall fishmonger" })
            // this.provider.insert('content', IdGen.generate(), { title: "moor think", text: "tell proclaims bell ignorant purposeto swore appur… inky marriagevows horse gertrude virtues seasond" })
            // this.provider.insert('content', IdGen.generate(), { title: "transformation name womans hid shine", text: "garden drowns artless superfluous rank lingers sty… avoid feelingly suckd struggling whom spectators" })
            // this.provider.insert('content', IdGen.generate(), { title: "youll hang officers caviare", text: "clear rashly ungracious divinity desire oerstep th…lany afflicts plucks gravemaker necessary intents" })
            // this.provider.insert('content', IdGen.generate(), { title: "delay softly smells duppd harmony dismal", text: "come fits vigour se lobby lost giving holla beetle…ernancy carry retirement purged gravemaking usual" })
            // this.provider.insert('content', IdGen.generate(), { title: "pleasant", text: "thither debate tropically utterd all caps stranger…reconcilement guarded permanent siege sustain wed" })
            // this.provider.insert('content', IdGen.generate(), { title: "events marrow following", text: "berattle duties gentle oerbears soles unmixd divul…ess chorus idle lain diligence consummation dozen" })
            // this.provider.insert('content', IdGen.generate(), { title: "beauty", text: "hasten caught blame blow concernings pate southerl…vior weight thin quoted touches trade ostentation" })
            // this.provider.insert('content', IdGen.generate(), { title: "blasted poison apprehension school", text: "foolish feed worm stoops seest fiction rest lay fa…mperance insolence beget lights overcame sickness" })
            // this.provider.insert('content', IdGen.generate(), { title: "attractive", text: "bed radiant brothers falconers sober nephews infec…lleys german purport carters religious each snuff" })
            // this.provider.insert('content', IdGen.generate(), { title: "infinite utterance cannot", text: "quake puts person contagious heavenly cockle place…s meed upshot disjoint fiction grave bought child" })
            // this.provider.insert('content', IdGen.generate(), { title: "unpeg sickly hear folly ingenious", text: "coped seek c wondrous apprehension supply hire hedge weight seducewon mortised" })
            // this.provider.insert('content', IdGen.generate(), { title: "instrumental thunders monday defy", text: "female deaths weapon die digs oerhasty ha corrupte…ted wick deserved outherods defeats outface roars" })
            // this.provider.insert('content', IdGen.generate(), { title: "player possession counter swounds", text: "tonight err desert beggar changeling commingled to…ought aptly leaves push weak windlasses turbulent" })
            // for (let i = 0; i < 40; i++) {
            //     this.provider.insert('content', IdGen.generate(), {
            //         title: this.datagen.hamlet(Math.random() * 7),
            //         text: this.datagen.hamlet(Math.random() * 200)
            //     })
            // }
        }
    }

    private async _init(datasource: string) {
        if (typeof datasource === 'undefined') {
            return
        }
        const data = await this.provider.getAll(datasource)
        if (data.length === 0) {
            const generator = this.generators[datasource.trim()]
            if (typeof generator === 'function') {
                generator()
                // console.log(`--------------------${datasource.trim()}-----------------------`)
                // const data = await (this.provider.dumpdb())
                // const generated = data.filter(_ => _.partition_key === datasource.trim())
                // console.log(generated)
                // console.log(`--------------------${datasource.trim()}-----------------------`)
            }
        }
    }

    private async _initTokenization(datasource: string, query: any) {
        if (typeof datasource === 'undefined') {
            return
        }
        const tokenization = this.tokenizations[datasource]
        if (typeof tokenization === 'undefined') {
            this.tokenizations[datasource] = await this.provider.tokenize(datasource, query)
        }
    }

    async all(datasource: string): Promise<Array<string>> {
        await this._init(datasource)
        return await this.provider.getAll(datasource)
    }

    async stats(datasource: string, process: any): Promise<Array<any>> {
        await this._init(datasource)
        return await this.provider.stats(datasource, process)
    }

    async sample(datasource: string, count: number = 10): Promise<Array<any>> {
        await this._init(datasource)
        const a = await this.provider.sample(datasource, count)
        // console.log(`datasource:${datasource}|a:${a}|dump:${await this.provider.dumpdb(p => p.partition_key === datasource)}`)
        return a
    }

    async query(datasource: string, query: any): Promise<Array<any>> {
        await this._init(datasource)
        return await this.provider.query(datasource, query)
    }

    public async getAllByIds(datasource: string, ids: Array<string>): Promise<any> {
        await this._init(datasource)
        return await this.provider.getAllByIds(datasource, ids)
    }

    public async ensureTokenization(datasource: string, tokenizationExpression: any): Promise<any> {
        await this._init(datasource)
        await this._initTokenization(datasource, tokenizationExpression)
        return 0
    }

    public async tokenizationTerms(datasource: string): Promise<any> {
        const tokenization = this.tokenizations[datasource]
        if (typeof tokenization === 'undefined') {
            throw new Error('Tokenization not initialized. Call ensureTokenization first.')
        }
        return await tokenization.terms()
    }

    public async tokenizationScan(datasource: string, text: string): Promise<any> {
        const tokenization = this.tokenizations[datasource]
        if (typeof tokenization === 'undefined') {
            throw new Error('Tokenization not initialized. Call ensureTokenization first.')
        }
        return await tokenization.scan(text)
    }

    public async tokenizationTop(datasource: string, text: string): Promise<any> {
        const tokenization = this.tokenizations[datasource]
        if (typeof tokenization === 'undefined') {
            throw new Error('Tokenization not initialized. Call ensureTokenization first.')
        }
        return await tokenization.top(text)
    }

    public async tokenizationFilter(datasource: string, filterExpression: any): Promise<any> {
        const tokenization = this.tokenizations[datasource]
        if (typeof tokenization === 'undefined') {
            throw new Error('Tokenization not initialized. Call ensureTokenization first.')
        }
        return await tokenization.filter(filterExpression)
    }

    public async tokenizationSerializeIDs(filterResults: any): Promise<any> {
        const transformed = Object.keys(filterResults).map(p => {
            const v = filterResults[p]
            return {
                p,
                score: v.sum,
                items: v.spread
            }
        })
        let ids = []
        for (const a of transformed) {
            const keys = Object.keys(a.items)
                .map(p => parseInt(p))
                .sort((a, b) => {
                    if (a < b) return 1
                    if (a > b) return -1
                    return 0
                })
            for (const key of keys) {
                let value = a.items[key]
                do {
                    if (ids.includes(value.value) === false) {
                        ids.push(value.value)
                    }
                    value = value.next
                }
                while (typeof value !== 'undefined')
            }
        }
        return ids
    }
}